<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['prefix' => LaravelLocalization::setLocale()], function()
{
    Route::group(['namespace' => 'Admin'],function(){
        Route::get('/', 'HomeController@front');
        Route::post('/', 'HomeController@SendFB');
    });

// Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');
});
Route::group(['namespace' =>'Admin'], function() {
    Route::get('/admin/login','AuthController@loginForm')->name('login');
    Route::post('/logout','AuthController@logout')->name('logout');
    Route::post('/admin/login','AuthController@login');
});

Route::group(['namespace' =>'Admin'], function() {
    Route::group(['prefix' => 'dashboard', 'middleware' => 'auth:web' ], function() {
        Route::get('/', 'HomeController@index');
        Route::resource('/sliders', 'SliderController');
        Route::resource('/projects', 'ProjectController');
        Route::resource('/services', 'ServiceController');
        Route::resource('/admins', 'AdminController');
        Route::resource('/feedbacks', 'FeedBackController');

        Route::group(['prefix' => 'settings'], function() {
            Route::get('/set-null/{table}/{id}/{column}', 'SettingController@SetNull')->name('set-null');
            Route::get('/site', 'SettingController@index');
            Route::post('/site', 'SettingController@store');
        });
    });
});
