<!doctype html>
<html lang="en">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<!-- fonts -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link
		href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,300;0,400;0,500;0,700;0,900;1,300;1,400&display=swap"
		rel="stylesheet">
	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="/css/bootstrap.min.css">
	<link rel="stylesheet" href="/css/font-awesome.min.css">
	<link rel="stylesheet" href="/css/swiper.min.css">
	<link rel="stylesheet" href="/css/animate.css">
	<link rel="stylesheet" href="/css/lightbox.css">
	<link rel="stylesheet" href="/css/myCss.css">
    @if (\Config::get('app.locale') == 'ar')
	 <link rel="stylesheet" href="/css/RTL.css">
    @endif
	<title>@if (\Config::get('app.locale') == 'ar')
        {{@$info['site_name_ar'] ?? ''}}
        @else
        {{@$info['site_name_en'] ?? ''}}
        @endif</title>
</head>
<body>
	<div class="upper-cont">
		<nav class="navbar cstm-nav">
			<div class="container">
				<div class="d-flex">
					<span class="navbar-brand">
						<img src="/cdn/{{$info['logo'] ?? ''}}" alt="">
					</span>

					<div class="nav-abs">
						<div class="dropdown">
							<a class="btn  dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
								data-toggle="dropdown" aria-expanded="false">
                                @if (\Config::get('app.locale') == 'ar')
								<img src="/pic/sa.svg" alt="">
								<span> (AR)</span>

                                @else
								<img src="/pic/gb.svg" alt="">
								<span> (EN)</span>

                                @endif

							</a>
							<div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
								<a class="dropdown-item" href="/ar"><img src="/pic/sa.svg" alt=""> AR</a>
								<a class="dropdown-item" href="/en"><img src="/pic/gb.svg" alt=""> EN</a>
							</div>
						</div>
					</div>
				</div>

			</div>

		</nav>
		<div class="swiper main-slider">
			<div class="swiper-wrapper">
                @foreach ($sliders as $item)
				<div class="swiper-slide">
					<img src="/cdn/{{$item->image}}" alt="">
				</div>

                @endforeach
			</div>
			<div class="swiper-button-prev"></div>
			<div class="swiper-button-next"></div>
		</div>
	</div>


	<section id="aboutUs" class="main-sec">
		<div class="container tabs-cont overflow-hidden">
			<div class="row">
				<div class="col-lg-6">
					<div class="img-wr wow fadeInLeft animated">
						<img src="/cdn/{{$info['page_banner'] ?? ''}}" alt="">
					</div>

				</div>
				<div class="col-lg-6 tabs-col">
                    @if (\Config::get('app.locale') == 'ar')
					<div class="sec-title">عن <span class="brown">الموقع</span> </div>
                    @else
					<div class="sec-title">ABOUT <span class="brown">US</span> </div>
                    @endif
					<div class="tabs-wr">
						<ul class="nav nav-tabs" id="myTab" role="tablist">
                            @if (\Config::get('app.locale') == 'ar')
							<li class="nav-item" role="presentation">
								<a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab"
									aria-controls="home" aria-selected="true">عن الموقع</a>
							</li>
							<li class="nav-item" role="presentation">
								<a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab"
									aria-controls="profile" aria-selected="false">مهام الشركة</a>
							</li>
							<li class="nav-item" role="presentation">
								<a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact" role="tab"
									aria-controls="contact" aria-selected="false">الشركاء</a>
							</li>
                            @else
							<li class="nav-item" role="presentation">
								<a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab"
									aria-controls="home" aria-selected="true">About Us</a>
							</li>
							<li class="nav-item" role="presentation">
								<a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab"
									aria-controls="profile" aria-selected="false">Mission</a>
							</li>
							<li class="nav-item" role="presentation">
								<a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact" role="tab"
									aria-controls="contact" aria-selected="false">Partner</a>
							</li>
                            @endif
						</ul>
						<div class="tab-content" id="myTabContent">
							<div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
								@if (\Config::get('app.locale') == 'ar')
                                {{$info['about_ar'] ?? ''}}
                                @else
                                {{$info['about_en'] ?? ''}}
                                @endif

							</div>
							<div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
								@if (\Config::get('app.locale') == 'ar')
                                {{$info['mission_ar'] ?? ''}}
                                @else
                                {{$info['mission_en'] ?? ''}}
                                @endif
							</div>
							<div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
								@if (\Config::get('app.locale') == 'ar')
                                {{$info['partner_ar'] ?? ''}}
                                @else
                                {{$info['partner_en'] ?? ''}}
                                @endif
							</div>
						</div>
					</div>


				</div>
			</div>

		</div>

	</section>
	<section class="main-sec bg-sec">
		<div class="container overflow-hidden">
            @if (\Config::get('app.locale') == 'ar')
			<div class="sec-title text-center mb-0">لماذا  <span class="brown">نحن</span> </div>
            @else
			<div class="sec-title text-center mb-0">WHY <span class="brown">US</span> </div>
            @endif
            @php
                $i = 2;
            @endphp
            @foreach ($services as $ser)
                @if ($i % 2 == 0)

                <div class="row brand-row">
                    <div class="col-12 col-lg-6 text-col ">
                        <div class="brand-card text-center wow fadeInUp animated">

                            <h4 class="brown"> {{\Config::get('app.locale') == 'ar'? $ser->title_ar : $ser->title_en}} </h4>
                            <p>
                                {{\Config::get('app.locale') == 'ar'? $ser->content_ar : $ser->content_en}}
                            </p>


                        </div>

                    </div>
                    <div class="col-12 col-lg-6 pic-col">
                        <a href="">
                            <div class="img-wr wow fadeInLeft animated" data-wow-duration="1s">
                                <img src="/cdn/{{$ser->image}}" alt="">
                            </div>
                        </a>

                    </div>

                </div>
                @else
                <div class="row brand-row">
                    <div class="col-12 col-lg-6 pic-col">
                        <a href="">
                            <div class="img-wr wow fadeInLeft animated" data-wow-duration="1s">
                                <img src="/cdn/{{$ser->image}}" alt="">
                            </div>
                        </a>

                    </div>
                    <div class="col-12 col-lg-6 text-col ">
                        <div class="brand-card text-center wow fadeInUp animated">

                            <h4 class="brown"> {{\Config::get('app.locale') == 'ar'? $ser->title_ar : $ser->title_en}} </h4>
                            <p>
                                {{\Config::get('app.locale') == 'ar'? $ser->content_ar : $ser->content_en}}
                            </p>


                        </div>

                    </div>

                </div>

                @endif
                @php
                    $i++;
                @endphp
            @endforeach
		</div>
	</section>
	<section class="vid-sec">
		<div class="container">

			<div class="embed-responsive embed-responsive-16by9">
				<div class="embed-responsive-item">
					<div id="player"></div>
				</div>
			</div>

		</div>
	</section>

	<section class="pic-sec main-sec">
		<div class="container">
            @if (\Config::get('app.locale') == 'ar')
			<div class="sec-title  mb-2">مشاريع <span class="brown">الشركة</span> </div>
            @else
			<div class="sec-title  mb-2">OUR <span class="brown">PROJECTS</span> </div>
            @endif
			<div class="row">
                @foreach ($projects as $pro)
				<div class="col-lg-4 col-md-6">
                        <a href="/cdn/{{$pro->image}}" data-lightbox="{{$pro->id}}" class="pic-wr">
						<img src="/cdn/{{$pro->image}}" alt="">
						<h3 class="pic-text">
							<div class="inner">
								@if (\Config::get('app.locale') == 'ar')
                                {{$pro->title_ar ?? ''}}
                                @else
                                {{$pro->title_en ?? ''}}
                                @endif
							</div>

						</h3>
                        </a>
				</div>

                @endforeach
			</div>
		</div>

	</section>
	<section id="contactUs" class="main-sec">
		<div class="container">

			<div class="row">
				<div class="col-xl-6">

					<form class="mx-auto form-style " method="post" id="form">
                        @csrf
                        @if (\Config::get('app.locale') == 'ar')
                        <div class="sec-title">اتصل <span class="brown">بنا</span> </div>
                        <p>يرجي ادخال كافه الحقول.</p>
                        @else
                        <div class="sec-title">Contact <span class="brown">Us</span> </div>
                        <p>Fill out the form to start the conversation.</p>
                    @endif
						<div class="row">
                            @if (\Config::get('app.locale') == 'ar')
                            <div class="col-md-6">
                                <input required type="text" name="name" class="form-control" placeholder="الاسم">
                            </div>
                            <div class="col-md-6">
                                <input required type="email" name="email" class="form-control" placeholder="البريد الالكتروني">
                            </div>
                            <div class="col-sm-12 mt-2">
                                <textarea required class="form-control" name="content" placeholder="نبذة عن مشروعك"
                                    rows="5"></textarea>
                            </div>
                            @else
                            <div class="col-md-6">
                                <input required type="text" name="name" class="form-control" placeholder="Your Name">
                            </div>
                            <div class="col-md-6">
                                <input required type="email" name="email" class="form-control" placeholder="E-mail Address">
                            </div>
                            <div class="col-sm-12 mt-2">
                                <textarea required class="form-control" name="content" placeholder="Tell us about your Project"
                                    rows="5"></textarea>
                            </div>
        @endif

							<div class="col-12 btn-wr">
                                @if (\Config::get('app.locale') == 'ar')
                                <button type="submit" class="btn btn-style1 rev shadow"><span>ارسال</span> </button>
                                @else
                                <button type="submit" class="btn btn-style1 rev shadow"><span>Send Now</span> </button>
                    @endif
							</div>
                            <p id="msg"></p>
						</div>
					</form>
				</div>
				<div class="col-xl-6 d-none bg-col d-xl-block">
					<div class="img-wr">
						<img src="/cdn/{{$info['player_image']}}" alt="">
					</div>

				</div>
			</div>
		</div>
	</section>


	<footer>
		<div class="container">
			<div class="row">

				<div class="col-lg-4 col-sm-6">
					<div class="d-flex">
						<span class="i-wr">
							<i class="fs" data-feather="phone"></i>
						</span>
						<span class="info">
							<strong>{{\Config::get('app.locale') == 'ar' ? 'اتصل بنا' : 'Call us'}}</strong>
							<div> {{@$info['phone']}}</div>
						</span>
					</div>
				</div>
				<div class="col-lg-4 col-sm-6">
					<div class="d-flex">
						<span class="i-wr">
							<i class="fs" data-feather="mail"></i>
						</span>
						<span class="info">
							<strong>{{\Config::get('app.locale') == 'ar' ? 'البريد الالكتروني' : 'Mail us'}}</strong>
							<div> {{@$info['email']}}</div>
						</span>
					</div>
				</div>
				<div class="col-lg-4 col-md-12">
					<div class="d-flex">
						<span class="i-wr">
							<i class="fs" data-feather="map-pin"></i>
						</span>
						<span class="info">
							<strong>{{\Config::get('app.locale') == 'ar' ? 'العنوان' : 'Find us'}}</strong>
							<div> {{\Config::get('app.locale') == 'ar' ? $info['address_ar'] : $info['address_en']}} </div>
						</span>
					</div>
				</div>
				<div class="col-12 footer-bottom">
					@if (\Config::get('app.locale') == 'ar')
                <div class="copy"> جميع الحقوق محفوظة {{\Carbon\Carbon::now()->format('Y')}} © @if (\Config::get('app.locale') == 'ar')
        {{@$info['site_name_ar'] ?? ''}}
        @else
        {{@$info['site_name_en'] ?? ''}}
        @endif </div>
                @else
                <div class="copy"> Copyrights {{\Carbon\Carbon::now()->format('Y')}} © @if (\Config::get('app.locale') == 'ar')
        {{@$info['site_name_ar'] ?? ''}}
        @else
        {{@$info['site_name_en'] ?? ''}}
        @endif </div>
                    @endif
					<div class="social">
						<a target="_blank" href="{{@$info['facebook']}}"> <i class="fs2" data-feather="facebook"> </i> </a>
						<a target="_blank" href="{{@$info['twitter']}}"> <i class="fs2" data-feather="twitter"> </i> </a>
						<a target="_blank" href="{{@$info['instagram']}}"> <i class="fs2" data-feather="instagram"> </i> </a>
						<a target="_blank" href="{{@$info['linkedin']}}"> <i class="fs2" data-feather="linkedin"> </i> </a>

					</div>
				</div>

			</div>
		</div>

	</footer>




	<!-- Optional JavaScript -->

	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
	<script src="/js/jquery-3.4.1.min.js"></script>
	<script src="/js/popper.min.js"></script>
	<script src="/js/bootstrap.min.js"></script>
	<script src="/js/swiper.min.js"></script>
	<!-- <script src="/js/jquery.marquee.min.js"></script> -->
	<script src="https://unpkg.com/feather-icons"></script>
	<script>
		feather.replace()
	</script>
	<script src="/js/wow.min.js"></script>
	<script src="/js/lightbox.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/clappr@latest/dist/clappr.min.js"></script>

    <script>
		var player = new Clappr.Player({
			source: "/vid/production ID_5077814.mp4",
			// baseUrl: "http://example.com/assets/clappr",
			parentId: "#player",
			poster: 'vid/blue.jpeg',
			mute: false,
			width: '100%',
			height: '100%',
			// mediacontrol: {
			// 	seekbar: "#1A4D3E",
			// 	buttons: "#1A4D3E"
			// },

		});
	</script>
	<script src="/js/myJquery.js"></script>
	<script src="/js/jquery.validate.min.js"></script>
    @if (\Config::get('app.locale') == 'ar')
	<script src="/js/messages_ar.js"></script>

    @endif
	<script>
		wow = new WOW({
			boxClass: 'wow', // default
			animateClass: 'animated', // default
			offset: 150, // default
			mobile: false, // default
			live: true, // default

		})
		wow.init();

        $('#form').validate();

        $(document).on('submit', '#form', function(e){
            e.preventDefault();
            var data = $(this).serializeArray();
            $.post("{{url()->current()}}", data)
            .done(function(res){
                if (res['code'] == '200') {
                    $('#msg').addClass('success');
                    $('#msg').removeClass('error');
                    $('#msg').html(res['msg']);
                } else {
                    $('#msg').removeClass('success');
                    $('#msg').addClass('error');
                    $('#msg').html(res['msg']);

                }
            })
            .fail(function(res){})
        })
	</script>

</body>

</html>
