<?php

namespace App\Http\Controllers\Admin;

// use App\Http\Requests\Admin\UpdatesliderRequest;
// use App\Http\Requests\Admin\StoresliderRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\SliderOperations;
use Illuminate\Http\Request;
use App\Slider;
use Auth;

class SliderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function index()
    {
        $sliders = Slider::latest()->get();
        $title = 'الصور';
        return view('admin.sliders.index', compact('sliders', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة قسم';
        return view('admin.sliders.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate(['image' => 'required|image'], $request->all());
        $slider = new Slider;
        $file = $request->file('image');
        $ext = $file->getClientOriginalExtension();
        $filename = rand(99999, 99999999) . time(). '.' . $ext;
        $file->move(public_path('/cdn'), $filename);

        $slider->image = $filename;
        $slider->save();
        return redirect(route('sliders.index'))->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Slider $slider)
    {
        $title = 'عرض الصورة';
        return view('admin.sliders.show', compact('slider', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $slider = Slider::find($id);
        $title = 'تعديل الصور';
        return view('admin.sliders.edit', compact('slider', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $request->validate(['image' => 'required|image'], $request->all());
        $slider = Slider::find($id);
        if ($slider->image) {
            @unlink(public_path('/cdn/'.$slider->image));
        }
        $file = $request->file('image');
        $ext = $file->getClientOriginalExtension();
        $filename = rand(99999, 99999999) . time(). '.' . $ext;
        $file->move(public_path('/cdn'), $filename);

        $slider->image = $filename;
        $slider->save();

        return redirect(route('sliders.index'))->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Slider $slider)
    {
        if ($slider->image) {
            @unlink(public_path('/cdn/'.$slider->image));
        }
        $slider->delete();
        return 'success';
    }
    public function logout()
    {
        Auth::logout();
        return redirect('/login');
    }
}
