<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Setting;
use DB;

class SettingController extends Controller
{

    public function SetNull(Request $request, $table, $id, $column)
    {
        DB::table($table)->where('id', $id)->update([$column => null]);
    }
    public function index()
    {
        $setting = Setting::pluck('value', 'key');
        // return $setting;
        $title = 'الاعدادات';
        return view('admin.settings.create', compact('setting', 'title'));
    }
    public function reports()
    {
        $setting = Setting::pluck('value', 'key');
        // return $setting;
        $title = 'التقارير';
        return view('admin.settings.reports', compact('setting', 'title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $setting = $request->get('setting');
        // return $setting;
        foreach ($setting as $key => $value) {
            Setting::updateOrcreate(['key' => $key],['value' => $value]);
        }

        if ($request->hasFile('logo')) {
            $logo = $this->uploadImage($request->file('logo'));
            Setting::updateOrcreate(['key' => 'logo'], ['value' => $logo]);
        }
        if ($request->hasFile('android_image')) {
            $android_image = $this->uploadImage($request->file('android_image'));
            Setting::updateOrcreate(['key' => 'android_image'], ['value' => $android_image]);
        }
        if ($request->hasFile('ios_image')) {
            $ios_image = $this->uploadImage($request->file('ios_image'));
            Setting::updateOrcreate(['key' => 'ios_image'], ['value' => $ios_image]);
        }
        if ($request->hasFile('android_image_case_no_app')) {
            $android_image_case_no_app = $this->uploadImage($request->file('android_image_case_no_app'));
            Setting::updateOrcreate(['key' => 'android_image_case_no_app'], ['value' => $android_image_case_no_app]);
        }
        if ($request->hasFile('file')) {
            $ios_image_case_no_app = $this->uploadImage($request->file('file'));
            Setting::updateOrcreate(['key' => 'file'], ['value' => $ios_image_case_no_app]);
        }
        if ($request->hasFile('web_image')) {
            $web_image = $this->uploadImage($request->file('web_image'));
            Setting::updateOrcreate(['key' => 'web_image'], ['value' => $web_image]);
        }
        if ($request->hasFile('player_image')) {
            $player_image = $this->uploadImage($request->file('player_image'));
            Setting::updateOrcreate(['key' => 'player_image'], ['value' => $player_image]);
        }
        if ($request->hasFile('page_banner')) {
            $page_banner = $this->uploadImage($request->file('page_banner'));
            Setting::updateOrcreate(['key' => 'page_banner'], ['value' => $page_banner]);
        }
        if ($request->hasFile('web_holiday_image')) {
            $web_holiday_image = $this->uploadImage($request->file('web_holiday_image'));
            Setting::updateOrcreate(['key' => 'web_holiday_image'], ['value' => $web_holiday_image]);
        }
        $ch = curl_init();
        $url = "https://ufm.loc.sa/api/v1/home";
        curl_setopt($ch,CURLOPT_URL,$url);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    //  curl_setopt($ch,CURLOPT_HEADER, false);

        $output=curl_exec($ch);
        return redirect()->back()->with('success', 'data added successfully');
    }

    public function uploadImage($file)
    {
        if( $file->getClientOriginalExtension() == 'php' || $file->getClientOriginalExtension() == 'html' || $file->getClientOriginalExtension() == 'sql' )
        {
            $ext = 'fucku';
            return 'is_'.auth()->id().'_cdn';
        }else{
            $ext = $file->getClientOriginalExtension();

        }
        $uploader = '';
        if(auth()->user())
        {
            $uploader = 'is_'.auth()->id().'_cdn';
        }
        $filename = rand(99999, 99999999) . $uploader . time(). '.' . $ext;
        $file->move(public_path('/cdn'), $filename);
        // $profileimg  = $filename;
        return $filename;
    }
}
