<?php

namespace App\Http\Controllers\Admin;

// use App\Http\Requests\Admin\UpdateserviceRequest;
// use App\Http\Requests\Admin\StoreserviceRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\ServiceOperations;
use Illuminate\Http\Request;
use App\Service;
use Auth;

class ServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function index()
    {
        $services = Service::latest()->get();
        $title = 'الكل';
        return view('admin.services.index', compact('services', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        return view('admin.services.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'nullable|image',
            'title_ar' => 'required',
            // 'title_en' => 'required',
        ], $request->all());
        $service = new Service;
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $ext = $file->getClientOriginalExtension();
            $filename = rand(99999, 99999999) . time(). '.' . $ext;
            $file->move(public_path('/cdn'), $filename);
            $service->image = $filename;
        }
        $service->title_ar = $request->title_ar;
        // $service->title_en = $request->title_en;
        $service->content_ar = $request->content_ar;
        // $service->content_en = $request->content_en;
        $service->save();
        return redirect(route('services.index'))->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Service $service)
    {
        $title = 'عرض ';
        return view('admin.services.show', compact('service', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $service = Service::find($id);
        $title = 'تعديل ';
        return view('admin.services.edit', compact('service', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $request->validate([
            'image' => 'nullable|image',
            'title_ar' => 'required',
            // 'title_en' => 'required',
        ], $request->all());
        $service = Service::find($id);
        if ($request->hasFile('image')) {
            if ($service->image) {
                @unlink(public_path('/cdn/'.$service->image));
            }
            $file = $request->file('image');
            $ext = $file->getClientOriginalExtension();
            $filename = rand(99999, 99999999) . time(). '.' . $ext;
            $file->move(public_path('/cdn'), $filename);

            $service->image = $filename;

        }
        $service->title_ar = $request->title_ar;
        // $service->title_en = $request->title_en;
        $service->content_ar = $request->content_ar;
        // $service->content_en = $request->content_en;
        $service->save();

        return redirect(route('services.index'))->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Service $service)
    {
        if ($service->image) {
            @unlink(public_path('/cdn/'.$service->image));
        }
        $service->delete();
        return 'success';
    }
    public function logout()
    {
        Auth::logout();
        return redirect('/login');
    }
}
