<?php

namespace App\Http\Controllers\Admin;

// use App\Http\Requests\Admin\UpdateProjectRequest;
// use App\Http\Requests\Admin\StoreProjectRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\ProjectOperations;
use Illuminate\Http\Request;
use App\Project;
use Auth;

class ProjectController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function index()
    {
        $projects = Project::latest()->get();
        $title = 'الكل';
        return view('admin.projects.index', compact('projects', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        return view('admin.projects.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'nullable|image',
            'title_ar' => 'required',
            'title_en' => 'required',
        ], $request->all());
        $Project = new Project;
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $ext = $file->getClientOriginalExtension();
            $filename = rand(99999, 99999999) . time(). '.' . $ext;
            $file->move(public_path('/cdn'), $filename);
            $Project->image = $filename;
        }
        $Project->title_ar = $request->title_ar;
        $Project->title_en = $request->title_en;
        // $Project->content_ar = $request->content_ar;
        // $Project->content_en = $request->content_en;
        $Project->save();
        return redirect(route('projects.index'))->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Project $Project)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $project = Project::find($id);
        $title = 'تعديل ';
        return view('admin.projects.edit', compact('project', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $request->validate([
            'image' => 'nullable|image',
            'title_ar' => 'required',
            'title_en' => 'required',
        ], $request->all());
        $Project = Project::find($id);
        if ($request->hasFile('image')) {
            if ($Project->image) {
                @unlink(public_path('/cdn/'.$Project->image));
            }
            $file = $request->file('image');
            $ext = $file->getClientOriginalExtension();
            $filename = rand(99999, 99999999) . time(). '.' . $ext;
            $file->move(public_path('/cdn'), $filename);

            $Project->image = $filename;

        }
        $Project->title_ar = $request->title_ar;
        $Project->title_en = $request->title_en;
        // $Project->content_ar = $request->content_ar;
        // $Project->content_en = $request->content_en;
        $Project->save();

        return redirect(route('projects.index'))->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Project $Project)
    {
        if ($Project->image) {
            @unlink(public_path('/cdn/'.$Project->image));
        }
        $Project->delete();
        return 'success';
    }
}
