<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Transaction;
use App\Models\Order;
use App\Models\Post;
use App\FeedBack;
use App\Project;
use App\Service;
use App\Setting;
use App\Slider;
use Carbon\Carbon;
use Validator;

class HomeController extends Controller
{
    public function index()
    {

        $users_chart = [];/*Post::whereDate('created_at', '>=', Carbon::now()->subMonths(6) )
                            ->whereDate('created_at', '<=', Carbon::now())
                            ->select( \DB::raw('COUNT(*) as a, DATE_FORMAT(created_at, "%Y-%m") as y'))
                            // ->groupBy('user_id')
                            ->groupBy('y')
                            ->get();*/
        $actions_chart = [];/*Action::whereDate('created_at', '>=', Carbon::now()->subMonths(6) )
                            ->whereDate('created_at', '<=', Carbon::now())
                            ->select( \DB::raw('COUNT(*) as a, DATE_FORMAT(created_at, "%Y-%m") as y'))
                            // ->groupBy('user_id')
                            ->groupBy('y')
                            ->get();*/
        $orders_chart = [];/*Transaction::whereDate('created_at', '>=', Carbon::now()->subMonths(6) )
                            ->whereDate('created_at', '<=', Carbon::now())
                            ->select( \DB::raw('SUM(`amount`) as a, DATE_FORMAT(created_at, "%Y-%m") as y'))
                            // ->groupBy('user_id')
                            ->groupBy('y')
                            ->get()->each(function($p){
                                $x = Carbon::parse($p->y)->subYears(1)->format('Y-m');
                                $x = Transaction::whereDate('created_at', $x)->sum('amount');
                                $p->b = $x;
                            });*/

    	$now = Carbon::now();
        $orders = [];//Order::latest();
    	$search = array();

        // $orders = $orders->paginate(10);
    	return view('admin.main', compact('search', 'users_chart', 'actions_chart', 'orders_chart', 'orders'));
    }
    public function front(){
        \Config::set('app.locale','ar');
        $info = Setting::pluck('value', 'key')->toArray();
        $services = Service::get();
        $sliders = Slider::get();
        $projects = Project::get();
        return view('welcome', compact('info', 'services', 'projects', 'sliders'));

    }

    public function SendFB(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'first_name' => 'required',
            'email' => 'required',
            'phone' => 'required'
        ]);
        if ($validator->fails()) {
            if (true) {
                $msg = 'يرجي ادخال كافة الحقول';
            } else {
                $msg = 'Please Fill All Fields';
            }

            return ['code' => 100, 'msg' => $msg];
        }
        $row = new FeedBack;
        $row->name = $request->first_name . ' ' . $request->last_name;
        $row->email = $request->email;
        $row->content = $request->phone;
        $row->source = $request->get('source');
        $row->save();
        if (true) {
            $msg = 'تم ارسال الرساله بنجاح و سيتم التوصل معكم في اقرب وقت.';
        } else {
            $msg = 'Your Message Has been send , and will contact with you soon.';
        }

        return ['code' => 200, 'msg' => $msg];
    }
}
