<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateAdminRequest;
use App\Http\Requests\Admin\StoreAdminRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\AdminOperations;
use Illuminate\Http\Request;
use App\User as Admin;
use Auth;

class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function index()
    {
        // $all = Admin::latest()->get();
        $admins = Admin::get();
        $title = 'نوع الحساب';
        return view('admin.admins.index', compact('admins', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        return view('admin.admins.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'image' => 'nullable|image',
            'password' => 'required|min:8'
        ], $request->all() );
        $user = new Admin;
        $user->name = $request->name;
        $user->email = $request->email;
        $user->password = bcrypt($request->password);
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $ext = $file->getClientOriginalExtension();
            $filename = rand(99999, 99999999) . time(). '.' . $ext;
            $file->move(public_path('/cdn'), $filename);
            $user->image = $filename;
        }
        $user->save();
        return redirect('/dashboard/admins')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Admin $admin)
    {
        $title = 'عرض ';
        return view('admin.admins.show', compact('admin', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $admin = Admin::find($id);
        $title = 'تعديل ';
        return view('admin.admins.edit', compact('admin', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email,'.$id,
            'image' => 'nullable|image',
            'password' => 'nullable|min:8'
        ], $request->all() );
        // $user = new Admin;
        $user = Admin::find($id);
        $user->name = $request->name;
        $user->email = $request->email;
        if($request->has('password') && $request->password != '')
            $user->password = bcrypt($request->password);
        if ($request->hasFile('image')) {
            if ($user->image) {
                @unlink(public_path('/cdn/'.$user->image));
            }
            $file = $request->file('image');
            $ext = $file->getClientOriginalExtension();
            $filename = rand(99999, 99999999) . time(). '.' . $ext;
            $file->move(public_path('/cdn'), $filename);
            $user->image = $filename;
        }
        $user->save();

        return redirect('dashboard/admins');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Admin $admin)
    {
        if ($admin->image) {
            @unlink(public_path('/cdn/'.$admin->image));
        }
        $admin->delete();
        return 'success';
    }
    public function logout()
    {
        Auth::logout();
        return redirect('/login');
    }
}
